//@author: colorsound
//@help: 
//@tags: Decay HlSL

//Map function for adapting values
#include "Map.fxh"

struct DecayS
{
float prev;
float curr;
float diffValue;
float dirValue;
float processValue;
};

SamplerState mySampler : IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

//Make a Texture to get the audio values
Texture1D ffttex;
 
RWStructuredBuffer<DecayS> Output : BACKBUFFER;

StructuredBuffer<float2> uv;

float Gain=100;
float InterpolateA = 20;

float Attack=0.8;
float Decay=0.99;

[numthreads(128, 1, 1)]
void Decay_CS( uint3 i : SV_DispatchThreadID)
{ 

 float diffValue = Output[i.x].diffValue ; 
 //Input the value from Current to the Previous slot
 Output[i.x].prev = Output[i.x].curr;
	
 //sample the audio values
 float fft = ffttex.SampleLevel(mySampler,(uv[i.x].x/InterpolateA),0).r *Gain;//this will add AudioFFT
	
 //Insert desired values 
 Output[i.x].curr =fft;

 float curr = Output[i.x].curr;
 float prev = Output[i.x].prev;

 //Get the difference
 diffValue = curr-prev;
 //Get direction of value and map to 0-1
 Output[i.x].dirValue = MapClamp(sign(diffValue),-1,1,0,1);	
 float dirValue = Output[i.x].dirValue;

 //If the value goes up do a IIR filter with Attack
 if (dirValue==1)
 Output[i.x].curr =lerp(curr,prev,Attack);
 //If the value goes down do a IIR filter with Decay
 if(dirValue==0)
 Output[i.x].curr =lerp(curr,prev,Decay);

 //Output result Value to other shader
 Output[i.x].processValue = Output[i.x].curr;
	
}

technique11 TDecay
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, Decay_CS() ) );
	}
}



